﻿using System;
using Microsoft.SharePoint;

namespace DoesUserHavePermissions
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            SPWeb web = site.RootWeb;

            SPListCollection lists = web.Lists;

            foreach (SPList l in lists)
            {
               try
               {
                  // Überprüfe, ob der Benutzer Berechtigungen abfragen kann
                  if (l.DoesUserHavePermissions
                     (SPBasePermissions.EnumeratePermissions))
                  {
                     Console.WriteLine("Liste: {0}", l.Title);

                     // Überprüfe, ob der Benutzer Elemente löschen darf
                     if (l.DoesUserHavePermissions
                        (SPBasePermissions.DeleteListItems))
                     {
                        Console.WriteLine("User kann Elemente löschen");
                     }
                     else
                     {
                        Console.WriteLine("User kann Elemente NICHT löschen");
                     }
                  }
               }
               catch (UnauthorizedAccessException)
               {
                  Console.WriteLine("User kann Rechte nicht abfragen");
               }
            }
         }
      }
   }
}